﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RimWorld;
using Verse;

namespace ArkhamEstate
{
    class Building_StreetLamp : Building
    {
        private ThingWithComps_Glower glower;
        private ThingDef glowerDef = ThingDef.Named("Jecrell_GasLampGlower");

        private void ResolveGlower()
        {
            if (glower == null)
            {
                Thing thing = ThingMaker.MakeThing(glowerDef, null);
                IntVec3 position = this.Position + GenAdj.CardinalDirections[0]
                                                 + GenAdj.CardinalDirections[0];
                GenPlace.TryPlaceThing(thing, position, this.Map, ThingPlaceMode.Near);
                glower = thing as ThingWithComps_Glower;
                glower.master = this;
            }
        }

        public override void SpawnSetup(Map map)
        {
            base.SpawnSetup(map);
            ResolveGlower();
        }

        public override void DeSpawn()
        {
            base.DeSpawn();
        }

        public override void ExposeData()
        {
            base.ExposeData();
            Scribe_References.LookReference<ThingWithComps_Glower>(ref this.glower, "glower", false);
        }
    }
}
